/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authc.rest;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.SearchGuardModulesRegistry;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.authc.base.AuthcResult;
import com.floragunn.searchguard.authc.blocking.BlockedIpRegistry;
import com.floragunn.searchguard.authc.blocking.BlockedUserRegistry;
import com.floragunn.searchguard.authc.legacy.LegacyRestAuthenticationProcessor;
import com.floragunn.searchguard.authc.legacy.LegacySgConfig;
import com.floragunn.searchguard.authc.rest.RestAuthcConfig;
import com.floragunn.searchguard.authc.rest.RestAuthenticationProcessor;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import com.floragunn.searchguard.user.AuthDomainInfo;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.action.RestApi;
import com.floragunn.searchsupport.action.StandardResponse;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.floragunn.searchsupport.diag.DiagnosticContext;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class AuthenticatingRestFilter
implements ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(AuthenticatingRestFilter.class);
    private final AuditLog auditLog;
    private final org.elasticsearch.common.util.concurrent.ThreadContext threadContext;
    private final PrincipalExtractor principalExtractor;
    private final Settings settings;
    private final Path configPath;
    private final DiagnosticContext diagnosticContext;
    private final AdminDNs adminDns;
    private final ComponentState componentState = new ComponentState(1, "authc", "rest_filter");
    private volatile RestAuthenticationProcessor authenticationProcessor;

    public AuthenticatingRestFilter(ConfigurationRepository configurationRepository, final SearchGuardModulesRegistry modulesRegistry, final AdminDNs adminDns, final BlockedIpRegistry blockedIpRegistry, final BlockedUserRegistry blockedUserRegistry, final AuditLog auditLog, final ThreadPool threadPool, PrincipalExtractor principalExtractor, final PrivilegesEvaluator privilegesEvaluator, Settings settings, Path configPath, DiagnosticContext diagnosticContext) {
        this.adminDns = adminDns;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.principalExtractor = principalExtractor;
        this.settings = settings;
        this.configPath = configPath;
        this.diagnosticContext = diagnosticContext;
        configurationRepository.subscribeOnChange(new ConfigurationChangeListener(){

            @Override
            public void onChange(ConfigMap configMap) {
                SgDynamicConfiguration<RestAuthcConfig> config = configMap.get(CType.AUTHC);
                SgDynamicConfiguration<LegacySgConfig> legacyConfig = configMap.get(CType.CONFIG);
                if (config != null && config.getCEntry("default") != null) {
                    RestAuthenticationProcessor.Default authenticationProcessor = new RestAuthenticationProcessor.Default(config.getCEntry("default"), modulesRegistry, adminDns, blockedIpRegistry, blockedUserRegistry, auditLog, threadPool, privilegesEvaluator);
                    AuthenticatingRestFilter.this.authenticationProcessor = authenticationProcessor;
                    AuthenticatingRestFilter.this.componentState.replacePartsWithType("config", config.getComponentState());
                    AuthenticatingRestFilter.this.componentState.replacePartsWithType("rest_authentication_processor", authenticationProcessor.getComponentState());
                    AuthenticatingRestFilter.this.componentState.updateStateFromParts();
                    if (log.isDebugEnabled()) {
                        log.debug("New configuration:\n" + config.getCEntry("default").toYamlString());
                    }
                } else if (legacyConfig != null && legacyConfig.getCEntry("sg_config") != null) {
                    LegacyRestAuthenticationProcessor authenticationProcessor = new LegacyRestAuthenticationProcessor(legacyConfig.getCEntry("sg_config"), modulesRegistry, adminDns, blockedIpRegistry, blockedUserRegistry, auditLog, threadPool, privilegesEvaluator);
                    AuthenticatingRestFilter.this.authenticationProcessor = authenticationProcessor;
                    AuthenticatingRestFilter.this.componentState.replacePartsWithType("config", legacyConfig.getComponentState());
                    AuthenticatingRestFilter.this.componentState.replacePartsWithType("rest_authentication_processor", authenticationProcessor.getComponentState());
                    AuthenticatingRestFilter.this.componentState.updateStateFromParts();
                    if (log.isDebugEnabled()) {
                        log.debug("New legacy configuration:\n" + legacyConfig.getCEntry("sg_config").toYamlString());
                    }
                } else {
                    AuthenticatingRestFilter.this.componentState.setState(ComponentState.State.SUSPENDED, "no_configuration");
                }
            }
        });
    }

    public RestHandler wrap(RestHandler original) {
        return new AuthenticatingRestHandler(original);
    }

    public RestAuthenticationProcessor getAuthenticationProcessor() {
        return this.authenticationProcessor;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private static boolean containsBadHeader(RestRequest request) {
        for (String key : request.getHeaders().keySet()) {
            if (key == null || !key.trim().toLowerCase().startsWith("_sg_".toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static class DebugApi
    extends RestApi {
        public static final String PATH = "/_searchguard/auth/debug";

        public DebugApi() {
            this.name(PATH);
            this.handlesGet(PATH).with((r, c) -> channel -> channel.sendResponse(new StandardResponse(404, new StandardResponse.Error("The /_searchguard/auth/debug API is not enabled. See the sg_authc configuration.")).toRestResponse()));
        }
    }

    class AuthenticatingRestHandler
    implements RestHandler {
        private final RestHandler original;

        AuthenticatingRestHandler(RestHandler original) {
            this.original = original;
        }

        public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
            ThreadContext.clearAll();
            AuthenticatingRestFilter.this.diagnosticContext.traceActionStack(request.getHttpRequest().method() + " " + request.getHttpRequest().uri());
            if (!this.checkRequest(this.original, request, channel, client)) {
                return;
            }
            if (this.isAuthcRequired(request)) {
                String sslPrincipal = (String)AuthenticatingRestFilter.this.threadContext.getTransient("_sg_ssl_principal");
                if (AuthenticatingRestFilter.this.adminDns.isAdminDN(sslPrincipal)) {
                    User user = new User(sslPrincipal, AuthDomainInfo.TLS_CERT);
                    AuthenticatingRestFilter.this.threadContext.putTransient("_sg_user", (Object)user);
                    AuthenticatingRestFilter.this.auditLog.logSucceededLogin(user, true, null, request);
                    this.original.handleRequest(request, channel, client);
                    return;
                }
                if (AuthenticatingRestFilter.this.authenticationProcessor == null) {
                    log.error("Not yet initialized (you may need to run sgctl)");
                    channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.SERVICE_UNAVAILABLE, "Search Guard not initialized (SG11). See https://docs.search-guard.com/latest/sgctl"));
                    return;
                }
                AuthenticatingRestFilter.this.authenticationProcessor.authenticate(this.original, request, channel, result -> {
                    if (AuthenticatingRestFilter.this.authenticationProcessor.isDebugEnabled() && "/_searchguard/auth/debug".equals(request.path())) {
                        this.sendDebugInfo(channel, (AuthcResult)result);
                        return;
                    }
                    if (result.getStatus() == AuthcResult.Status.PASS) {
                        AuthenticatingRestFilter.this.threadContext.putTransient("_sg_user", (Object)result.getUser());
                        ThreadContext.clearAll();
                        ThreadContext.put((String)"user", result.getUser() != null ? result.getUser().getName() : null);
                        try {
                            this.original.handleRequest(request, channel, client);
                        }
                        catch (Exception e) {
                            log.error("Error in " + this.original, (Throwable)e);
                            try {
                                channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
                            }
                            catch (IOException e1) {
                                log.error((Object)e1);
                            }
                        }
                    } else {
                        ThreadContext.remove((String)"user");
                        if (result.getRestStatus() != null && result.getRestStatusMessage() != null) {
                            BytesRestResponse response = this.isJsonResponseRequested(request) ? new BytesRestResponse(result.getRestStatus(), "application/json", DocNode.of((String)"status", (Object)result.getRestStatus().getStatus(), (String)"error.reason", (Object)result.getRestStatusMessage(), (String)"error.type", (Object)"authentication_exception").toJsonString()) : new BytesRestResponse(result.getRestStatus(), result.getRestStatusMessage());
                            if (!result.getHeaders().isEmpty()) {
                                result.getHeaders().forEach((k, v) -> v.forEach(e -> response.addHeader(k, e)));
                            }
                            channel.sendResponse((RestResponse)response);
                        }
                    }
                }, e -> {
                    try {
                        channel.sendResponse((RestResponse)new BytesRestResponse(channel, e));
                    }
                    catch (IOException e1) {
                        log.error((Object)e1);
                    }
                });
            } else {
                this.original.handleRequest(request, channel, client);
            }
        }

        private boolean isJsonResponseRequested(RestRequest request) {
            String accept = request.header("accept");
            return accept != null && (accept.startsWith("application/json") || accept.startsWith("application/vnd.elasticsearch+json"));
        }

        private boolean isAuthcRequired(RestRequest request) {
            return request.method() != RestRequest.Method.OPTIONS && !"/_searchguard/license".equals(request.path()) && !"/_searchguard/license".equals(request.path()) && !"/_searchguard/health".equals(request.path()) && (!"/_searchguard/auth/session".equals(request.path()) || request.method() != RestRequest.Method.POST);
        }

        private boolean checkRequest(RestHandler restHandler, RestRequest request, RestChannel channel, NodeClient client) throws Exception {
            AuthenticatingRestFilter.this.threadContext.putTransient("_sg_origin", (Object)AuditLog.Origin.REST.toString());
            if (AuthenticatingRestFilter.containsBadHeader(request)) {
                ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
                log.error((Object)exception);
                AuthenticatingRestFilter.this.auditLog.logBadHeaders(request);
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)exception));
                return false;
            }
            if (SSLRequestHelper.containsBadHeader((org.elasticsearch.common.util.concurrent.ThreadContext)AuthenticatingRestFilter.this.threadContext, (String)"_sg_")) {
                ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
                log.error((Object)exception);
                AuthenticatingRestFilter.this.auditLog.logBadHeaders(request);
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)exception));
                return false;
            }
            try {
                SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo((Settings)AuthenticatingRestFilter.this.settings, (Path)AuthenticatingRestFilter.this.configPath, (RestRequest)request, (PrincipalExtractor)AuthenticatingRestFilter.this.principalExtractor);
                if (sslInfo != null) {
                    if (sslInfo.getPrincipal() != null) {
                        AuthenticatingRestFilter.this.threadContext.putTransient("_sg_ssl_principal", (Object)sslInfo.getPrincipal());
                    }
                    if (sslInfo.getX509Certs() != null) {
                        AuthenticatingRestFilter.this.threadContext.putTransient("_sg_ssl_peer_certificates", (Object)sslInfo.getX509Certs());
                    }
                    AuthenticatingRestFilter.this.threadContext.putTransient("_sg_ssl_protocol", (Object)sslInfo.getProtocol());
                    AuthenticatingRestFilter.this.threadContext.putTransient("_sg_ssl_cipher", (Object)sslInfo.getCipher());
                }
            }
            catch (SSLPeerUnverifiedException e) {
                log.error("No ssl info", (Throwable)e);
                AuthenticatingRestFilter.this.auditLog.logSSLException(request, e);
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)e));
                return false;
            }
            return true;
        }

        private void sendDebugInfo(RestChannel channel, AuthcResult authcResult) {
            BytesRestResponse response = new BytesRestResponse(authcResult.getRestStatus(), "application/json", authcResult.toPrettyJsonString());
            if (!authcResult.getHeaders().isEmpty()) {
                authcResult.getHeaders().forEach((arg_0, arg_1) -> AuthenticatingRestHandler.lambda$sendDebugInfo$5((RestResponse)response, arg_0, arg_1));
            }
            channel.sendResponse((RestResponse)response);
        }

        private static /* synthetic */ void lambda$sendDebugInfo$5(RestResponse response, String k, List v) {
            v.forEach(e -> response.addHeader(k, e));
        }
    }
}

